<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Axtra HTML5 Template">

    <!-- Primary Meta Tags -->
    <title><?php echo e($seo['title'] ?? ''); ?> <?php echo $__env->yieldContent('title'); ?></title>
    <meta name="title" content="<?php echo e($seo['title'] ?? ''); ?>">
    <meta name="description" content="<?php echo e($seo['description'] ?? ''); ?>">
    <meta name="keywords" content="<?php echo e($seo['keywords'] ?? ''); ?>">

    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?php echo e($seo['url'] ?? url()->current()); ?>">
    <meta property="og:title" content="<?php echo e($seo['title'] ?? ''); ?>">
    <meta property="og:description" content="<?php echo e($seo['description'] ?? ''); ?>">
    <meta property="og:image" content="<?php echo e($seo['image'] ?? asset('assets/imgs/logo/favicon.png')); ?>">
    <meta property="og:site_name" content="<?php echo e(config('app.name')); ?>">

    <!-- Twitter -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:url" content="<?php echo e($seo['url'] ?? url()->current()); ?>">
    <meta name="twitter:title" content="<?php echo e($seo['title'] ?? ''); ?>">
    <meta name="twitter:description" content="<?php echo e($seo['description'] ?? ''); ?>">
    <meta name="twitter:image" content="<?php echo e($seo['image'] ?? asset('assets/imgs/logo/favicon.png')); ?>">

    <link rel="canonical" href="<?php echo e($seo['url'] ?? url()->current()); ?>">

    <title>Home - Digital Marketing</title>
    <!-- Fav Icon -->
    <link rel="icon" type="image/x-icon" href="assets/imgs/logo/favicon.png">
    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com/">
    <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Kanit:wght@300;400;500;600;700&amp;display=swap"
        rel="stylesheet">
    <!-- All CSS files -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/all.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/swiper-bundle.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/progressbar.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/meanmenu.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/master.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('resposnive.css')); ?>">

</head>

<body>
    <?php
    $logo = App\Models\Logo::first();
    
    $logoPath = public_path($logo->logo); // full system path
    
    $ourServices = App\Models\OurServices::all();
    
    $linkLists = App\Models\socialLink::all();
    
    ?>
    <!-- Cursor Animation -->
    <div class="cursor1"></div>
    <div class="cursor2"></div>


    <!-- Preloader -->
    <div class="preloader">
        <div class="loading">
            <div class="bar bar1"></div>
            <div class="bar bar2"></div>
            <div class="bar bar3"></div>
            <div class="bar bar4"></div>
            <div class="bar bar5"></div>
            <div class="bar bar6"></div>
            <div class="bar bar7"></div>
            <div class="bar bar8"></div>
        </div>
    </div>


    <!-- Switcher Area Start -->
    <div class="switcher__area">
        <div class="switcher__icon">
            <button id="switcher_open"><i class="fa-solid fa-gear"></i></button>
            <button id="switcher_close"><i class="fa-solid fa-xmark"></i></button>
        </div>

        <div class="switcher__items">
            <div class="switcher__item">
                <div class="switch__title-wrap">
                    <h2 class="switcher__title">Cursor</h2>
                </div>
                <div class="switcher__btn">
                    <select name="cursor-style" id="cursor_style">
                        <option value="1">default</option>
                        <option selected value="2">animated</option>
                    </select>
                </div>
            </div>

            <div class="switcher__item">
                <div class="switch__title-wrap">
                    <h2 class="switcher__title">mode</h2>
                </div>
                <div class="switcher__btn mode-type wc-col-2">
                    <button class="active" data-mode="light">light</button>
                    <button data-mode="dark">dark</button>
                </div>
            </div>

            <div class="switcher__item">
                <div class="switch__title-wrap">
                    <h2 class="switcher__title">Language Support</h2>
                </div>
                <div class="switcher__btn lang_dir wc-col-2">
                    <button class="active" data-mode="ltr">LTR</button>
                    <button data-mode="rtl">RTL</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Switcher Area End -->



    <!-- Scroll Smoother -->
    <div class="has-smooth" id="has_smooth"></div>


    <!-- Go Top Button -->
    <button id="scroll_top" class="scroll-top"><i class="fa-solid fa-arrow-up"></i></button>


    <!-- Header area start -->
    <header class="header__area-3">
        <div class="header__inner-3">
            <div class="header__logo-2">
                <!-- <a href="index.html" class="logo-dark"><img src="assets/imgs/logo/logo-black.png" alt="Site Logo"></a>
        <a href="index.html" class="logo-light"><img src="assets/imgs/logo/site-logo-white-2.png" alt="Site Logo"></a> -->

                <a href="<?php echo e(url('/')); ?>" class="logo-dark">
                    <?php if($logo && $logo->logo && file_exists($logoPath)): ?>
                        <img src="<?php echo e(asset($logo->logo)); ?>" alt="Site Logo" class="responsive-logo">
                    <?php else: ?>
                        <span class="text-danger">Logo not found</span>
                    <?php endif; ?>
                </a>

                <a href="<?php echo e(url('/')); ?>" class="logo-light">
                    <?php if($logo && $logo->logo && file_exists($logoPath)): ?>
                        <img src="<?php echo e(asset($logo->logo)); ?>" alt="Site Logo" class="responsive-logo">
                    <?php else: ?>
                        <span class="text-danger">Logo not found</span>
                    <?php endif; ?>
                </a>
            </div>

            <div class="header__nav-2">
                <ul class="main-menu-3 menu-anim">
                    <li class="has-megamenu"><a href="<?php echo e(route('index')); ?>">home</a></li>
                    <li><a href="#">Services</a>
                        <ul class="main-dropdown">
                            <?php $__empty_1 = true; $__currentLoopData = $ourServices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ourService): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <li><a
                                        href="<?php echo e(route('ourServiceDetails', $ourService->title)); ?>"><?php echo e($ourService->title ?? ''); ?></a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <?php endif; ?>




                        </ul>
                    </li>
                    <li class="has-megamenu"><a href="<?php echo e(route('Ta-ask-Story')); ?>">Ta-ask Story</a></li>
                    <li class="has-megamenu"><a href="<?php echo e(route('blog')); ?>">Blog</a></li>

                    <li class="has-megamenu"><a href="<?php echo e(route('contactUs')); ?>">Contact Us</a></li>



                </ul>
            </div>
            <div class="header__nav-icon-3">
                <button class="search-icon" id="search_icon"><i class="fa-solid fa-magnifying-glass"></i></button>
                <button class="search-icon" id="search_close"><i class="fa-solid fa-xmark"></i></button>
                <button id="open_offcanvas"><img src="<?php echo e(asset('assets/imgs/icon/menu-black.png')); ?>"
                        alt="Menubar Icon"></button>
            </div>
        </div>
    </header>


    <div class="header__search">
        <form action="#">
            <input type="text" name="s" id="s" placeholder="Search..">
        </form>
    </div>
    <!-- Header area end -->


    <!-- Offcanvas area start -->
    <div class="offcanvas__area">
        <div class="offcanvas__body">
            <div class="offcanvas__left">
                <div class="offcanvas__logo">

                    <a href="index.html">
                        <?php if($logo && $logo->logo && file_exists($logoPath)): ?>
                            
                            <img src="<?php echo e(asset($logo->logo)); ?>" alt="Offcanvas Logo">
                        <?php else: ?>
                        <?php endif; ?>
                    </a>
                </div>
                <div class="offcanvas__social">
                    <h3 class="social-title">Follow Us</h3>
                    <ul>
                        <?php $__empty_1 = true; $__currentLoopData = $linkLists; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $linkedListsss): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <li><a href="<?php echo e($linkedListsss->link); ?>"><?php echo e($linkedListsss->name); ?></a></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <?php endif; ?>

                    </ul>
                </div>

            </div>
            <div class="offcanvas__mid">
                <div class="offcanvas__menu-wrapper">
                    <nav class="offcanvas__menu">
                        <ul class="menu-anim">
                            <li><a href="<?php echo e(url('/')); ?>">home</a>

                            </li>
                            <li>
                                <a>Services</a>
                                <ul>
                                    <?php $__empty_1 = true; $__currentLoopData = $ourServices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ourService): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <li><a
                                                href="<?php echo e(route('ourServiceDetails', $ourService->title)); ?>"><?php echo e($ourService->title ?? ''); ?></a>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <?php endif; ?>

                                </ul>
                            </li>
                            <li>
                                <a href="<?php echo e(route('Ta-ask-Story')); ?>">Ta-Ask Story</a>

                            </li>
                            <li>
                                <a href="<?php echo e(route('blog')); ?>">Blog</a>

                            </li>
                            <li>
                                <a href="<?php echo e(route('contactUs')); ?>">Contact Us</a>

                            </li>



                        </ul>
                    </nav>
                </div>
            </div>
            <div class="offcanvas__right">
                
                
                <img src="assets/imgs/shape/11.png" alt="shape" class="shape-1">
                <img src="assets/imgs/shape/12.png" alt="shape" class="shape-2">
            </div>
            <div class="offcanvas__close">
                <button type="button" id="close_offcanvas"><i class="fa-solid fa-xmark"></i></button>
            </div>
        </div>
    </div>
    <!-- Offcanvas area end -->


    <div id="smooth-wrapper">
        <div id="smooth-content">
            <?php echo $__env->yieldContent('content'); ?>

            <script>
                document.querySelectorAll('.swiper-slide').forEach(function(slide) {
                    slide.addEventListener('click', function() {
                        var targetLink = this.getAttribute('data-link');
                        window.location.href = targetLink;
                    });
                });
            </script>

            <!-- Footer area start -->
            <footer class="footer__area-3">
                <div class="footer__top-3">
                    <div class="footer__top-wrapper-3">
                        <div class="footer__logo-3 pt-120">
                            <?php if($logo && $logo->logo && file_exists($logoPath)): ?>
                                <img src="<?php echo e(asset($logo->logo)); ?>" alt="Footer Logo">
                            <?php endif; ?>

                            
                        </div>
                        <div class="footer__social-3">
                            <ul>
                                <?php $__empty_1 = true; $__currentLoopData = $linkLists; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $linkLists): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <li><a href="<?php echo e($linkLists->link); ?>"><?php echo e($linkLists->name); ?></a></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <?php endif; ?>


                            </ul>
                        </div>
                        <div class="footer__contact-3">
                            <a class="end" href="<?php echo e(route('contactUs')); ?>">Let’s talk</a>
                        </div>
                    </div>
                </div>

                <div class="footer__btm-3">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-xxl-4 col-xl-4 col-lg-4">
                                <div class="footer__copyright-3">
                                    <!-- <p>© 2022 - 2025 | Alrights reserved by <a href="https://wealcoder.com/" target="_blank">Wealcoder</a>
                  </p> -->
                                </div>
                            </div>
                            <div class="col-xxl-8 col-xl-8 col-lg-8">
                                <div class="footer__nav-2">
                                    <ul class="footer-menu-2 menu-anim">
                                        <li><a href="<?php echo e(route('Ta-ask-Story')); ?>">The Ta-ask Story</a></li>
                                        <li><a href="<?php echo e(route('contactUs')); ?>">contact</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </footer>
            <!-- Footer area end -->


        </div>
    </div>



    <!-- All JS files -->
    <script src="<?php echo e(asset('assets/js/jquery-3.6.0.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/bootstrap.bundle.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/swiper-bundle.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/counter.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/gsap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/ScrollTrigger.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/ScrollToPlugin.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/ScrollSmoother.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/SplitText.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/chroma.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/mixitup.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/vanilla-tilt.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/jquery.meanmenu.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/main.js')); ?>"></script>

</body>




</html>
<?php /**PATH E:\Laravel Script\Agency Backend\User-Admin-Login\resources\views/app.blade.php ENDPATH**/ ?>