
<?php $__env->startSection('title', $blogDetails->slug ?? ''); ?>
<meta name="title" content="<?php echo e($blogDetails->meta_title ?? ($seo['title'] ?? '')); ?>">
<meta name="description" content="<?php echo e($blogDetails->meta_description ?? ($seo['description'] ?? '')); ?>">
<meta name="keywords" content="<?php echo e($blogDetails->meta_keywords ?? ($seo['keywords'] ?? '')); ?>">

<!-- Open Graph / Facebook -->
<meta property="og:type" content="article">
<meta property="og:url" content="<?php echo e(url()->current()); ?>">
<meta property="og:title" content="<?php echo e($blogDetails->meta_title ?? ($seo['title'] ?? '')); ?>">
<meta property="og:description" content="<?php echo e($blogDetails->meta_description ?? ($seo['description'] ?? '')); ?>">
<meta property="og:image"
    content="<?php echo e($blogDetails->image ? asset($blogDetails->image) : $seo['image'] ?? asset('assets/imgs/logo/favicon.png')); ?>">
<meta property="og:site_name" content="<?php echo e(config('app.name')); ?>">

<!-- Twitter -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:url" content="<?php echo e(url()->current()); ?>">
<meta name="twitter:title" content="<?php echo e($blogDetails->meta_title ?? ($seo['title'] ?? '')); ?>">
<meta name="twitter:description" content="<?php echo e($blogDetails->meta_description ?? ($seo['description'] ?? '')); ?>">
<meta name="twitter:image"
    content="<?php echo e($blogDetails->image ? asset($blogDetails->image) : $seo['image'] ?? asset('assets/imgs/logo/favicon.png')); ?>">
<?php $__env->startSection('content'); ?>
    <section class="blog__detail">
        <div class="container g-0 line pt-140">
            <span class="line-3"></span>
            <div class="row">
                <div class="col-xxl-8 col-xl-10 offset-xxl-2 offset-xl-1">
                    <div class="blog__detail-top">
                        <h2 class="blog__detail-date animation__word_come"><span>
                                <?php echo e($blogDetails->created_at->format('d M Y')); ?>

                            </span></h2>
                        <h3 class="blog__detail-title animation__word_come">
                            <?php echo e($blogDetails->title); ?>

                        </h3>

                    </div>
                </div>
                <div class="col-xxl-12">
                    <div class="blog__detail-thumb">
                        <?php if(isset($blogDetails->image) && public_path(file_exists($blogDetails->image))): ?>
                            <img src="<?php echo e(asset($blogDetails->image)); ?>" alt="Blog Thumbnail" data-speed="0.5">
                        <?php endif; ?>

                    </div>
                </div>
                <div class="col-xxl-8 col-xl-10 offset-xxl-2 offset-xl-1">
                    <div class="blog__detail-content">
                        <?php echo $blogDetails->content; ?>

                    </div>
                    <!-- <div class="blog__detail-tags">
                                                                                                    <p class="sub-title-anim">tags: <a href="tag.html">design</a>, <a
                                                                                                            href="tag.html">figma</a>,
                                                                                                        <a href="tag.html">update</a>
                                                                                                    </p>
                                                                                                </div> -->
                </div>
            </div>
        </div>
    </section>
    <style>
        .dark .blog__detail-content,
        .dark .blog__detail-content * {
            color: #fff !important;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\Laravel Script\Agency Backend\User-Admin-Login\resources\views/blogDetails.blade.php ENDPATH**/ ?>