
<?php $__env->startSection('content'); ?>
    <?php
        $defaultImage = asset('assets/images/no-img-avatar.png');
        $logoPath = $Logo && $Logo->logo && file_exists(public_path($Logo->logo)) ? asset($Logo->logo) : $defaultImage;
    ?>
    <div class="container-fluid">
        <div class="row">
            <div class="col-6">
                <div class="filter cm-content-box box-primary">
                    <div class="content-title">
                        <div class="cpa">
                            Featured Image
                        </div>
                        <div class="tools">
                            <a href="javascript:void(0);" class="expand SlideToolHeader"></a>
                        </div>
                    </div>
                    <div class="cm-content-body  publish-content form excerpt">
                        <div class="card-body">
                            <div class="avatar-upload d-flex align-items-center">
                                <form action="<?php echo e(route('admin.logoStore')); ?>" method="POST" enctype="multipart/form-data">
                                    <?php echo csrf_field(); ?>
                                    <!---error-->
                                    <?php if($errors->has('logo')): ?>
                                        <div class="text-danger mt-2">
                                            <?php echo e($errors->first('logo')); ?>

                                        </div>
                                    <?php endif; ?>
                                    <!--Success-->
                                    <?php if(session('success')): ?>
                                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                                            <?php echo e(session('success')); ?>

                                            <button type="button" class="btn-close" data-bs-dismiss="alert"
                                                aria-label="Close"></button>
                                        </div>
                                    <?php endif; ?>
                                    <div class=" position-relative ">
                                        <div class="avatar-preview">
                                            <div id="imagePreview" @endphp
                                                style="background-image: url('<?php echo e($logoPath); ?>');">
                                            </div>
                                        </div>
                                        <div class="change-btn d-flex align-items-center flex-wrap">
                                            <input type="file" class="form-control d-none" id="imageUpload"
                                                accept=".png, .jpg, .jpeg" name="logo">
                                            <label for="imageUpload" class="btn btn-primary ms-0">Select Image</label>
                                        </div>
                                        <div class="mb-3">
                                            <button type="submit" class="btn btn-primary">Submit</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
    <?php $__env->startPush('script'); ?>
        <script>
            $(document).ready(function() {
                function readURL(input) {
                    if (input.files && input.files[0]) {
                        var reader = new FileReader();
                        reader.onload = function(e) {
                            $('#imagePreview').css('background-image', 'url(' + e.target.result + ')');
                            $('#imagePreview').hide();
                            $('#imagePreview').fadeIn(650);
                        }
                        reader.readAsDataURL(input.files[0]);
                    }
                }

                $("#imageUpload").on('change', function() {
                    readURL(this);
                });

                $('.remove-img').on('click', function() {
                    var imageUrl = "/assets/images/no-img-avatar.png"; // Use correct asset URL
                    $('#imagePreview').css('background-image', 'url(' + imageUrl + ')');
                });
            });
        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.dashboard.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\Laravel Script\Agency Backend\User-Admin-Login\resources\views/admin/layouts/dashboard/homepage/logo.blade.php ENDPATH**/ ?>