<?php $__env->startSection('title', translate('language')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <!-- Page Title -->
        <div class="mb-4 pb-2">
            <h2 class="h1 mb-0 text-capitalize d-flex align-items-center gap-2">
                <img src="<?php echo e(asset('/public/assets/back-end/img/system-setting.png')); ?>" alt="">
                <?php echo e(translate('system_Setup')); ?>

            </h2>
        </div>
        <!-- End Page Title -->

        <!-- Inlile Menu -->
        <?php echo $__env->make('admin-views.business-settings.system-settings-inline-menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!-- End Inlile Menu -->

        <div class="row">
            <div class="col-md-12">
                <div class="alert alert-danger mb-3" role="alert">
                    <?php echo e(translate('changing_some_settings_will_take_time_to_show_effect_please_clear_session_or_wait_for_60_minutes_else_browse_from_incognito_mode')); ?>

                </div>

                <div class="card">
                    <div class="px-3 py-4">
                        <div class="row justify-content-between align-items-center flex-grow-1">
                            <div class="col-sm-4 col-md-6 col-lg-8 mb-2 mb-sm-0">
                                <h5 class="mb-0 d-flex">
                                    <?php echo e(translate('language_table')); ?>

                                </h5>
                            </div>
                            <div class="col-sm-8 col-md-6 col-lg-4">
                                <div class="d-flex gap-10 justify-content-sm-end">
                                    <button class="btn btn--primary btn-icon-split" data-toggle="modal" data-target="#lang-modal">
                                        <i class="tio-add"></i>
                                        <span class="text"><?php echo e(translate('add_new_language')); ?></span>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="table-responsive pb-3">
                        <table class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table" style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;">
                            <thead class="thead-light thead-50 text-capitalize">
                            <tr>
                                <th><?php echo e(translate('SL')); ?></th>
                                <th><?php echo e(translate('ID')); ?></th>
                                <th><?php echo e(translate('name')); ?></th>
                                <th><?php echo e(translate('code')); ?></th>
                                <th class="text-center"><?php echo e(translate('status')); ?></th>
                                <th class="text-center"><?php echo e(translate('default_status')); ?></th>
                                <th class="text-center"><?php echo e(translate('action')); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php ($language=App\Model\BusinessSetting::where('type','language')->first()); ?>
                            <?php $__currentLoopData = json_decode($language['value'],true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($key+1); ?></td>
                                    <td><?php echo e($data['id']); ?></td>
                                    <td><?php echo e($data['name']); ?> ( <?php echo e(isset($data['direction'])?$data['direction']:'ltr'); ?>

                                        )
                                    </td>
                                    <td><?php echo e($data['code']); ?></td>
                                    <td>


                                        <?php if(array_key_exists('default', $data) && $data['default']==true): ?>
                                            <label class="switcher mx-auto" onclick="default_language_status_alert()">
                                                <input type="checkbox" class="switcher_input" checked disabled>
                                                <span class="switcher_control"></span>
                                            </label>
                                        <?php else: ?>
                                            <form action="<?php echo e(route('admin.business-settings.language.update-status')); ?>" method="GET" id="language_id_<?php echo e($data['id']); ?>_form" class="language_id_form">
                                                <?php echo csrf_field(); ?>
                                                <input type="hidden" name="code" value="<?php echo e($data['code']); ?>">
                                                <label class="switcher mx-auto">
                                                    <input type="checkbox" class="switcher_input"
                                                    <?php echo e($data['status']==1?'checked':''); ?>

                                                    id="language_id_<?php echo e($data['id']); ?>" name="status" class="toggle-switch-input" onclick="toogleStatusModal(event,'language_id_<?php echo e($data['id']); ?>','language-on.png','language-off.png','<?php echo e(translate('Want_to_Turn_ON_Language_Status')); ?>','<?php echo e(translate('Want_to_Turn_OFF_Language_Status')); ?>',`<p><?php echo e(translate('if_enabled_this_language_will_be_available_throughout_the_entire_system')); ?></p>`,`<p><?php echo e(translate('if_disabled_this_language_will_be_hidden_from_the_entire_system')); ?></p>`)">
                                                    <span class="switcher_control"></span>
                                                </label>
                                            </form>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if(array_key_exists('default', $data) && $data['default']==true): ?>
                                        <label class="switcher mx-auto" onclick="default_language_status_alert()">
                                            <input type="checkbox" class="switcher_input" checked disabled>
                                            <span class="switcher_control"></span>
                                        </label>
                                        <?php elseif(array_key_exists('default', $data) && $data['default']==false): ?>
                                        <form action="<?php echo e(route('admin.business-settings.language.update-default-status', ['code'=>$data['code']])); ?>" method="GET" id="language_default_id_<?php echo e($data['id']); ?>_form" class="language_default_id_form">
                                            <?php echo csrf_field(); ?>
                                            <input type="hidden" name="code" value="<?php echo e($data['code']); ?>">
                                            <label class="switcher mx-auto">
                                                <input type="checkbox" class="switcher_input" id="language_default_id_<?php echo e($data['id']); ?>" name="default" class="toggle-switch-input" onclick="toogleStatusModal(event,'language_default_id_<?php echo e($data['id']); ?>','language-on.png','language-off.png','<?php echo e(translate('Want_to_Change_Default_Language_Status')); ?>','<?php echo e(translate('Want_to_Turn_OFF_Language_Status')); ?>',`<p><?php echo e(translate('if_enabled_this_language_will_be_set_as_default_for_the_entire_system')); ?></p>`,`<p><?php echo e(translate('if_disabled_this_language_will_be_unset_as_default_for_the_entire_system')); ?></p>`)">
                                                <span class="switcher_control"></span>
                                            </label>
                                        </form>
                                        <?php endif; ?>


                                    </td>
                                    <td class="text-center">
                                        <div class="dropdown">
                                            <button class="btn btn-seconary btn-sm dropdown-toggle"
                                                    type="button"
                                                    id="dropdownMenuButton" data-toggle="dropdown"
                                                    aria-haspopup="true"
                                                    aria-expanded="false">
                                                <i class="tio-settings"></i>
                                            </button>
                                            <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                                <?php if($data['code']!='en'): ?>
                                                    <a class="dropdown-item" data-toggle="modal"
                                                        data-target="#lang-modal-update-<?php echo e($data['code']); ?>"><?php echo e(translate('update')); ?></a>
                                                    <?php if($data['default']==true): ?>
                                                    <a class="dropdown-item"
                                                    href="javascript:" onclick="default_language_delete_alert()"><?php echo e(translate('delete')); ?></a>
                                                    <?php else: ?>
                                                        <a class="dropdown-item delete"
                                                            id="<?php echo e(route('admin.business-settings.language.delete',[$data['code']])); ?>"><?php echo e(translate('delete')); ?></a>

                                                    <?php endif; ?>
                                                <?php endif; ?>
                                                <a class="dropdown-item"
                                                    href="<?php echo e(route('admin.business-settings.language.translate',[$data['code']])); ?>"><?php echo e(translate('translate')); ?></a>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal fade" id="lang-modal" tabindex="-1" role="dialog"
             aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel"><?php echo e(translate('new_language')); ?></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form action="<?php echo e(route('admin.business-settings.language.add-new')); ?>" method="post"
                          style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;">
                        <?php echo csrf_field(); ?>
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-12">
                                    <div class="form-group">
                                        <label for="recipient-name"
                                               class="col-form-label"><?php echo e(translate('language')); ?> </label>
                                        <input type="text" class="form-control" id="recipient-name" name="name">
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="form-group">
                                        <label for="message-text"
                                               class="col-form-label"><?php echo e(translate('country_code')); ?></label>
                                        <select class="form-control country-var-select w-100" name="code">
                                            <?php $__currentLoopData = \Illuminate\Support\Facades\File::files(base_path('public/assets/front-end/img/flags')); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $path): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if(pathinfo($path)['filename'] !='en'): ?>
                                                    <option value="<?php echo e(pathinfo($path)['filename']); ?>"
                                                            title="<?php echo e(asset('public/assets/front-end/img/flags/'.pathinfo($path)['filename'].'.png')); ?>">
                                                        <?php echo e(strtoupper(pathinfo($path)['filename'])); ?>

                                                    </option>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="form-group">
                                        <label class="col-form-label"><?php echo e(translate('direction')); ?> :</label>
                                        <select class="form-control" name="direction">
                                            <option value="ltr">LTR</option>
                                            <option value="rtl">RTL</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary"
                                    data-dismiss="modal"><?php echo e(translate('close')); ?></button>
                            <button type="submit" class="btn btn--primary"><?php echo e(translate('add')); ?> <i
                                    class="fa fa-plus"></i></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <?php $__currentLoopData = json_decode($language['value'],true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="modal fade" id="lang-modal-update-<?php echo e($data['code']); ?>" tabindex="-1" role="dialog"
                 aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel"><?php echo e(translate('new_language')); ?></h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <form action="<?php echo e(route('admin.business-settings.language.update')); ?>" method="post">
                            <?php echo csrf_field(); ?>
                            <div class="modal-body">
                                <div class="row">
                                    <div class="col-12">
                                        <div class="form-group">
                                            <label for="recipient-name"
                                                   class="col-form-label"><?php echo e(translate('language')); ?> </label>
                                            <input type="text" class="form-control" value="<?php echo e($data['name']); ?>"
                                                   name="name">
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="form-group">
                                            <label for="message-text"
                                                   class="col-form-label"><?php echo e(translate('country_code')); ?></label>
                                            <select class="form-control country-var-select w-100" name="code">
                                                <?php $__currentLoopData = \Illuminate\Support\Facades\File::files(base_path('public/assets/front-end/img/flags')); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $path): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if(pathinfo($path)['filename'] !='en' && $data['code']==pathinfo($path)['filename']): ?>
                                                        <option value="<?php echo e(pathinfo($path)['filename']); ?>"
                                                                title="<?php echo e(asset('public/assets/front-end/img/flags/'.pathinfo($path)['filename'].'.png')); ?>">
                                                            <?php echo e(strtoupper(pathinfo($path)['filename'])); ?>

                                                        </option>
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="form-group">
                                            <label class="col-form-label"><?php echo e(translate('direction')); ?> :</label>
                                            <select class="form-control" name="direction">
                                                <option
                                                    value="ltr" <?php echo e(isset($data['direction'])?$data['direction']=='ltr'?'selected':'':''); ?>>
                                                    LTR
                                                </option>
                                                <option
                                                    value="rtl" <?php echo e(isset($data['direction'])?$data['direction']=='rtl'?'selected':'':''); ?>>
                                                    RTL
                                                </option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary"
                                        data-dismiss="modal"><?php echo e(translate('close')); ?></button>
                                <button type="submit" class="btn btn--primary"><?php echo e(translate('update')); ?> <i
                                        class="fa fa-plus"></i></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <!-- Page level plugins -->
    <script src="<?php echo e(asset('public/assets/back-end')); ?>/vendor/datatables/jquery.dataTables.min.js"></script>
    <script src="<?php echo e(asset('public/assets/back-end')); ?>/vendor/datatables/dataTables.bootstrap4.min.js"></script>

    <!-- Page level custom scripts -->
    <script>
        // Call the dataTables jQuery plugin
        $(document).ready(function () {
            $('#dataTable').DataTable();
        });

        $('.language_id_form').on('submit', function(event){
            event.preventDefault();

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                }
            });
            $.ajax({
                url: "<?php echo e(route('admin.business-settings.language.update-status')); ?>",
                method: 'GET',
                data: $(this).serialize(),
                success: function (data) {
                    toastr.success('<?php echo e(translate("status_updated_successfully")); ?>');
                    setTimeout(() => {
                        location.reload();
                    }, 1000);
                }
            });
        });
    </script>

    <script>
        $(document).ready(function () {
            // color select select2
            $('.country-var-select').select2({
                templateResult: codeSelect,
                templateSelection: codeSelect,
                escapeMarkup: function (m) {
                    return m;
                }
            });

            function codeSelect(state) {
                var code = state.title;
                if (!code) return state.text;
                return "<img class='image-preview' src='" + code + "'>" + state.text;
            }
        });
    </script>

    <script>
        $(document).ready(function () {
            $(".delete").click(function (e) {
                e.preventDefault();

                Swal.fire({
                    title: '<?php echo e(translate("are_you_sure_to_delete_this")); ?>?',
                    text: "<?php echo e(translate('you_will_not_be_able_to_revert_this')); ?>!",
                    showCancelButton: true,
                    confirmButtonColor: 'primary',
                    cancelButtonColor: 'secondary',
                    confirmButtonText: '<?php echo e(translate("yes_delete_it")); ?>!',
                    cancelButtonText: '<?php echo e(translate("cancel")); ?>',
                }).then((result) => {
                    if (result.value) {
                        window.location.href = $(this).attr("id");
                    }
                })
            });
        });

    </script>
    <script>
        function default_language_delete_alert()
        {
            toastr.warning('<?php echo e(translate("default_language_can_not_be_deleted")); ?>! <?php echo e(translate("to_delete_change_the_default_language_first")); ?>!');
        }
        function default_language_status_alert()
        {
            toastr.warning('<?php echo e(translate("default_language_can_not_be_deactive")); ?>!');
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/niloyrah/public_html/E-commerce2/resources/views/admin-views/business-settings/language/index.blade.php ENDPATH**/ ?>