<?php $__env->startSection('title',translate('refund_transactions')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid ">
        <!-- Page Title -->
        <div class="mb-3">
            <h2 class="h1 mb-0 text-capitalize d-flex align-items-center gap-2">
                <img width="20" src="<?php echo e(asset('/public/assets/back-end/img/order_report.png')); ?>" alt="">
                <?php echo e(translate('transaction_report')); ?>

            </h2>
        </div>
        <!-- End Page Title -->

        <!-- Inlile Menu -->
        <?php echo $__env->make('admin-views.report.transaction-report-inline-menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!-- End Inlile Menu -->

        <div class="card">
            <div class="card-header border-0 px-3 py-4">
                <div class="w-100 d-flex flex-wrap gap-3 align-items-center">
                    <h4 class="mb-0 mr-auto">
                        <?php echo e(translate('total_transaction')); ?>

                        <span class="badge badge-soft-dark radius-50 fz-14"><?php echo e($refund_transactions->total()); ?></span>
                    </h4>
                    <form action="<?php echo e(url()->current()); ?>" method="GET" class="mb-0">
                        <!-- Search -->
                        <div class="input-group input-group-merge input-group-custom">
                            <div class="input-group-prepend">
                                <div class="input-group-text">
                                    <i class="tio-search"></i>
                                </div>
                            </div>
                            <input id="datatableSearch_" type="search" name="search" class="form-control"
                                   placeholder="<?php echo e(translate('search_by_orders_id_or_refund_id')); ?>" aria-label="Search orders"
                                   value="<?php echo e($search); ?>">
                            <button type="submit" class="btn btn--primary"><?php echo e(translate('search')); ?></button>
                        </div>
                        <!-- End Search -->
                    </form>
                    <form action="#" id="form-data" method="GET">
                        <div class="d-flex flex-wrap gap-2 align-items-center">
                            <select class="form-control __form-control w-auto" name="payment_method" id="payment_method">
                                <option value="all" <?php echo e($payment_method=='all' ? 'selected': ''); ?>><?php echo e(translate('all')); ?></option>
                                <option value="cash" <?php echo e($payment_method=='cash' ? 'selected': ''); ?>><?php echo e(translate('cash')); ?></option>
                                <option value="digitally_paid" <?php echo e($payment_method=='digitally_paid' ? 'selected': ''); ?>><?php echo e(translate('digitally_paid')); ?></option>
                                <option value="customer_wallet" <?php echo e($payment_method=='customer_wallet' ? 'selected': ''); ?>><?php echo e(translate('customer_wallet')); ?></option>
                            </select>
                            <button type="submit" class="btn btn--primary px-4 min-w-120 __h-45px" onclick="formUrlChange(this)"
                                    data-action="<?php echo e(url()->current()); ?>">
                                <?php echo e(translate('filter')); ?>

                            </button>
                            <div>
                                <button type="button" class="btn btn-outline--primary text-nowrap btn-block"
                                        data-toggle="dropdown">
                                    <i class="tio-download-to"></i>
                                    <?php echo e(translate('export')); ?>

                                    <i class="tio-chevron-down"></i>
                                </button>
                                <ul class="dropdown-menu dropdown-menu-right">
                                    <li>
                                        <a class="dropdown-item"
                                           href="<?php echo e(route('admin.transaction.refund-transaction-export-excel', ['payment_method'=>$payment_method, 'search'=>$search])); ?>"  >
                                            <img width="14" src="<?php echo e(asset('/public/assets/back-end/img/excel.png')); ?>" alt="">
                                            <?php echo e(translate('excel')); ?>

                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <div class="table-responsive">
                <table id="datatable"
                       style="text-align: <?php echo e(Session::get('direction') === "rtl" ? 'right' : 'left'); ?>;"
                       class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table w-100 __table-refund">
                    <thead class="thead-light thead-50 text-capitalize">
                    <tr>
                        <th><?php echo e(translate('SL')); ?></th>
                        <th><?php echo e(translate('product')); ?></th>
                        <th><?php echo e(translate('refund_id')); ?></th>
                        <th><?php echo e(translate('order_id')); ?></th>
                        <th><?php echo e(translate('shop_name')); ?></th>
                        <th><?php echo e(translate('payment_method')); ?></th>
                        <th><?php echo e(translate('payment_status')); ?></th>
                        <th><?php echo e(translate('paid_by')); ?></th>
                        <th><?php echo e(translate('amount')); ?></th>
                        <th class="text-center"><?php echo e(translate('transaction_type')); ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $refund_transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$refund_transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr class="text-capitalize">
                            <td>
                                <?php echo e($refund_transactions->firstItem()+$key); ?>

                            </td>
                            <td>
                                <?php if($refund_transaction->order_details->product): ?>
                                    <a href="<?php echo e(route('admin.product.view',[$refund_transaction->order_details->product->id])); ?>" class="media align-items-center gap-2">
                                        <img src="<?php echo e(\App\CPU\ProductManager::product_image_path('thumbnail')); ?>/<?php echo e($refund_transaction->order_details->product->thumbnail); ?>" class="avatar border" alt="">
                                        <span class="media-body title-color hover-c1">
                                            <?php echo e(isset($refund_transaction->order_details->product->name) ? \Illuminate\Support\Str::limit($refund_transaction->order_details->product->name, 20) : ''); ?>

                                        </span>
                                    </a>
                                <?php else: ?>
                                    <span><?php echo e(translate('not_found')); ?></span>
                                <?php endif; ?>
                            </td>
                            <td class="text-center">
                                <?php if($refund_transaction->refund_id): ?>
                                    <a href="<?php echo e(route('admin.refund-section.refund.details',['id'=>$refund_transaction['refund_id']])); ?>" class="title-color hover-c1">
                                        <?php echo e($refund_transaction->refund_id); ?>

                                    </a>
                                <?php else: ?>
                                    <span><?php echo e(translate('not_found')); ?></span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <a href="<?php echo e(route('admin.orders.details',['id'=>$refund_transaction->order_id])); ?>" class="title-color hover-c1">
                                    <?php echo e($refund_transaction->order_id); ?>

                                </a>
                            </td>
                            <td>
                                <?php if($refund_transaction->order->seller_is == 'seller' && $refund_transaction->order->seller): ?>
                                    <?php echo e($refund_transaction->order->seller->shop->name); ?>

                                <?php else: ?>
                                    <?php echo e(translate('inhouse')); ?>

                                <?php endif; ?>
                            </td>

                            <td>
                                <?php echo e(translate(str_replace('_',' ',$refund_transaction->payment_method))); ?>

                            </td>
                            <td>
                                <?php echo e(translate(str_replace('_',' ',$refund_transaction->payment_status))); ?>

                            </td>
                            <td>
                                <?php echo e(translate($refund_transaction->paid_by)); ?>

                            </td>
                            <td>
                                <?php echo e(\App\CPU\Helpers::currency_converter($refund_transaction->amount)); ?>

                            </td>
                            <td class="text-center">
                                <?php echo e($refund_transaction->transaction_type == 'Refund' ? translate('refunded') : str_replace('_',' ',$refund_transaction->transaction_type)); ?>

                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <?php if(count($refund_transactions)==0): ?>
                    <div class="text-center p-4">
                        <img class="mb-3 w-160" src="<?php echo e(asset('public/assets/back-end')); ?>/svg/illustrations/sorry.svg"
                             alt="Image Description">
                        <p class="mb-0"><?php echo e(translate('no_data_to_show')); ?></p>
                    </div>
                <?php endif; ?>
            </div>

            <div class="table-responsive mt-4">
                <div class="px-4 d-flex justify-content-lg-end">
                    <!-- Pagination -->
                    <?php echo e($refund_transactions->links()); ?>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.back-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/niloyrah/public_html/E-commerce2/resources/views/admin-views/refund-transaction/list.blade.php ENDPATH**/ ?>