<?php if($method): ?>
        <?php
            $product_price_total=0;
            $total_tax=0;
            $total_shipping_cost=0;
            $order_wise_shipping_discount=\App\CPU\CartManager::order_wise_shipping_discount();
            $total_discount_on_product=0;
            $cart=\App\CPU\CartManager::get_cart();
            $cart_group_ids=\App\CPU\CartManager::get_cart_group_ids();
            $shipping_cost=\App\CPU\CartManager::get_shipping_cost();
            $get_shipping_cost_saved_for_free_delivery=\App\CPU\CartManager::get_shipping_cost_saved_for_free_delivery();
            $coupon_discount = session()->has('coupon_discount')?session('coupon_discount'):0;
            $coupon_dis=session()->has('coupon_discount')?session('coupon_discount'):0;
            if($cart->count() > 0){
                foreach($cart as $key => $cartItem){
                    $product_price_total+=$cartItem['price']*$cartItem['quantity'];
                    $total_tax+=$cartItem['tax_model']=='exclude' ? ($cartItem['tax']*$cartItem['quantity']):0;
                    $total_discount_on_product+=$cartItem['discount']*$cartItem['quantity'];
                }

                if(session()->missing('coupon_type') || session('coupon_type') !='free_delivery'){
                    $total_shipping_cost=$shipping_cost - $get_shipping_cost_saved_for_free_delivery;
                }else{
                    $total_shipping_cost=$shipping_cost;
                }

                $total_offline_amount = $product_price_total+$total_tax+$total_shipping_cost-$coupon_dis-$total_discount_on_product-$order_wise_shipping_discount;
            }
        ?>

    <!-- dynamic payment modal field section -->
    <div class="payment-list-area">
        
        <div class="bg-primary-light rounded p-4 mt-4 mx-xl-5">
            <h6 class="text-capitalize"><?php echo e($method->method_name); ?> <?php echo e(translate('info')); ?></h6>

            <div class="row g-2 fs-12">
                <?php $__currentLoopData = $method->method_fields; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $method_field): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-xl-5 col-sm-6">
                        <div class="d-flex gap-2">
                            <span class="text-muted text-capitalize"><?php echo e(translate($method_field['input_name'])); ?></span>   :   <span class="text-dark"><?php echo e(translate($method_field['input_data'])); ?></span>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>

        <h4 class="mt-4 font-weight-bold text-center"><?php echo e(translate('amount')); ?> : <?php echo e(\App\CPU\Helpers::currency_converter($total_offline_amount)); ?></h4>

        <div class="mx-xl-5">
            <div class="row">
                <input type="hidden" value="offline_payment" name="payment_method">
                <input type="hidden" value="<?php echo e($method->id); ?>" name="method_id">
                <?php
                    $count =  count($method->method_informations);
                    $count_status = $count%2 == 1 ? 'odd' : 'even';
                ?>
                <?php $__currentLoopData = $method->method_informations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$informations): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-sm-<?php echo e($key == 0 && $count_status==="odd" ? 12 : 6); ?>">
                        <div class="form-group">
                            <label for="payment_by"><?php echo e(translate($informations['customer_input'])); ?>

                                <span class="text-danger"><?php echo e($informations['is_required'] == 1?'*':''); ?></span>
                            </label>
                            <input type="text" name="<?php echo e($informations['customer_input']); ?>" class="form-control" placeholder="<?php echo e(translate($informations['customer_placeholder'])); ?>" <?php echo e($informations['is_required'] == 1?'required':''); ?>>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <div class="col-12">
                    <div class="form-group">
                        <label for="account_no"><?php echo e(translate('payment_note')); ?></label>
                        <textarea class="form-control" name="payment_note" rows="4" placeholder="<?php echo e(translate('insert_note')); ?>"></textarea>
                    </div>
                </div>
                <div class="col-12">
                    <div class="d-flex justify-content-end gap-3">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(translate('close')); ?></button>
                        <button type="submit" class="btn btn--primary"><?php echo e(translate('submit')); ?></button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- end of dynamic payment modal field section -->
<?php endif; ?>
<?php /**PATH /home/niloyrah/public_html/E-commerce2/resources/themes/default/web-views/partials/_pay_offline_method_list_fields.blade.php ENDPATH**/ ?>