<?php $__env->startSection('title', translate('customer_Details')); ?>

<?php $__env->startPush('css_or_js'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <!-- Page Header -->
        <div class="d-print-none pb-2">
            <div class="row align-items-center">
                <div class="col-sm mb-2 mb-sm-0">

                    <!-- Page Title -->
                    <div class="mb-3">
                        <h2 class="h1 mb-0 text-capitalize d-flex gap-2">
                            <img width="20" src="<?php echo e(asset('/public/assets/back-end/img/customer.png')); ?>" alt="">
                            <?php echo e(translate('customer_details')); ?>

                        </h2>
                    </div>
                    <!-- End Page Title -->

                    <div class="d-sm-flex align-items-sm-center">
                        <h3 class="page-header-title"><?php echo e(translate('customer_ID')); ?> #<?php echo e($customer['id']); ?></h3>
                        <span class="<?php echo e(Session::get('direction') === "rtl" ? 'mr-2 mr-sm-3' : 'ml-2 ml-sm-3'); ?>">
                        <i class="tio-date-range">
                        </i> <?php echo e(translate('joined_At')); ?> : <?php echo e(date('d M Y H:i:s',strtotime($customer['created_at']))); ?>

                        </span>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Page Header -->

        <div class="row" id="printableArea">
            <div class="col-lg-8 mb-3 mb-lg-0">
                <div class="card">
                    <div class="p-3">
                        <div class="row justify-content-end">
                            <div class="col-auto">
                                <form action="<?php echo e(url()->current()); ?>" method="GET">
                                    <!-- Search -->
                                    <div class="input-group input-group-merge input-group-custom">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text">
                                                <i class="tio-search"></i>
                                            </div>
                                        </div>
                                        <input id="datatableSearch_" type="search" name="search" class="form-control"
                                            placeholder="<?php echo e(translate('search_orders')); ?>" aria-label="Search orders" value="<?php echo e($search); ?>"
                                            required>
                                        <button type="submit" class="btn btn--primary"><?php echo e(translate('search')); ?></button>
                                    </div>
                                    <!-- End Search -->
                                </form>
                            </div>
                        </div>
                    </div>
                    <!-- Table -->
                    <div class="table-responsive datatable-custom">
                        <table
                               class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table w-100">
                            <thead class="thead-light thead-50 text-capitalize">
                            <tr>
                                <th><?php echo e(translate('sl')); ?></th>
                                <th><?php echo e(translate('order_ID')); ?></th>
                                <th><?php echo e(translate('total')); ?></th>
                                <th class="text-center"><?php echo e(translate('action')); ?></th>
                            </tr>

                            </thead>

                            <tbody>
                            <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($orders->firstItem()+$key); ?></td>
                                    <td>
                                        <a href="<?php echo e(route('admin.orders.details',['id'=>$order['id']])); ?>" class="title-color hover-c1"><?php echo e($order['id']); ?></a>
                                    </td>
                                    <td> <?php echo e(\App\CPU\BackEndHelper::set_symbol(\App\CPU\BackEndHelper::usd_to_currency($order['order_amount']))); ?></td>

                                    <td>
                                        <div class="d-flex justify-content-center gap-10">
                                            <a class="btn btn-outline--primary btn-sm edit square-btn"
                                                title="<?php echo e(translate('view')); ?>"
                                                href="<?php echo e(route('admin.orders.details',['id'=>$order['id']])); ?>"><i
                                                    class="tio-invisible"></i> </a>
                                            <a class="btn btn-outline-info btn-sm square-btn"
                                                title="<?php echo e(translate('invoice')); ?>"
                                                target="_blank"
                                                href="<?php echo e(route('admin.orders.generate-invoice',[$order['id']])); ?>"><i
                                                    class="tio-download"></i> </a>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                        <?php if(count($orders)==0): ?>
                            <div class="text-center p-4">
                                <img class="mb-3 w-160" src="<?php echo e(asset('public/assets/back-end')); ?>/svg/illustrations/sorry.svg" alt="Image Description">
                                <p class="mb-0"><?php echo e(translate('no_data_to_show')); ?></p>
                            </div>
                        <?php endif; ?>
                        <!-- Footer -->
                        <div class="card-footer">
                            <!-- Pagination -->
                        <?php echo $orders->links(); ?>

                        <!-- End Pagination -->
                        </div>
                        <!-- End Footer -->
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <!-- Card -->
                <div class="card">
                    <?php if($customer): ?>
                        <div class="card-body">
                            <h4 class="mb-4 d-flex align-items-center gap-2">
                                <img src="<?php echo e(asset('/public/assets/back-end/img/seller-information.png')); ?>" alt="">
                                <?php echo e(translate('customer')); ?>

                            </h4>

                            <div class="media">
                                <div class="mr-3">
                                    <img
                                        class="avatar rounded-circle avatar-70"
                                        onerror="this.src='<?php echo e(asset('public/assets/front-end/img/image-place-holder.png')); ?>'"
                                        src="<?php echo e(asset('storage/app/public/profile/'.$customer->image??'')); ?>"
                                        alt="Image">
                                </div>
                                <div class="media-body d-flex flex-column gap-1">
                                    <span class="title-color hover-c1"><strong><?php echo e($customer['f_name'].' '.$customer['l_name']); ?></strong></span>
                                    <span class="title-color">
                                        <strong><?php echo e(\App\Model\Order::where('customer_id',$customer['id'])->count()); ?> </strong><?php echo e(translate('orders')); ?>

                                    </span>
                                    <span class="title-color"><strong><?php echo e($customer['phone']); ?></strong></span>
                                    <span class="title-color"><?php echo e($customer['email']); ?></span>
                                </div>
                                <div class="media-body text-right">
                                    
                                </div>
                            </div>
                        </div>
                <?php endif; ?>

                <!-- End Body -->
                </div>
                <!-- End Card -->
            </div>
        </div>
        <!-- End Row -->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/niloyrah/public_html/E-commerce2/resources/views/admin-views/customer/customer-view.blade.php ENDPATH**/ ?>