
@extends('Frontend_1.layouts.app')
@section('content')
    @include('Frontend_1.layouts.header')
    <div class="container c_card mt-3 " style="">
        <div class="row">
            @if (Auth::check())

                <div class="col-lg-10 col-sm-12  col-xl-12 mb-4 mx-auto">
                    <div class="card">
                        <div class="card-header">
                            <h2>User Form</h2>
                            <?php
                            $find_user = App\Models\Information_store::where('user_id', Auth::user()->id)->first();
                            
                            ?>
                            @if (isset($find_user))
                                @if ($find_user->status == null)
                                    <span class="badge badge-pill badge-danger">Not Accepted By The Admin Yet!</span>
                                @else
                                    <span class="badge badge-pill badge-success">Accepted</span>
                                @endif
                            @endif
                            @if($find_user != null && $find_user->short_note != null)
    <span class="badge badge-pill badge-success">{{ $find_user->short_note }}</span>

@endif


                        </div>
                       

                        @if ($find_user)
                            {{-- {{$find_user->name}} --}}
                            <div class="card-body">
                                
                                <form method="POST" action="{{ route('user.update_information') }}"
                                    enctype="multipart/form-data">
                                    @csrf

                                    @if ($errors->any())
                                        <div class="text-danger">
                                            {!! implode('', $errors->all('<div>:message</div>')) !!}
                                        </div>
                                    @endif
                                    
                                    <div class="mb-3">
                                        <label for="name" class="form-label">Name(Nid)</label>
                                        <input type="text" class="form-control" name="name"
                                            value="{{ $find_user->name }}">
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label for="father_name" class="form-label">Father's Name</label>
                                        <input type="text" class="form-control" name="father_name"
                                            value="{{ $find_user->father_name }}">
                                    </div>
                                    <div class="mb-3">
                                        <label for="mother_name" class="form-label">Mother's Name</label>
                                        <input type="text" class="form-control" name="mother_name"
                                            value="{{ $find_user->mother_name }}">
                                    </div>

                                    <div class="mb-3">
                                        <label for="gender" class="form-label">Gender</label>
                                        <select name="gender" id="" class="form-control">

                                            <option value="male" @if ($find_user->gender == 'male') selected @endif>
                                                Male</option>
                                            <option value="Female" @if ($find_user->gender == 'Female') selected @endif>
                                                Female</option>

                                        </select>
                                    </div>

                                    @if ($find_user->married == 'married')
                                        <div class="mb-3">
                                            <label for="marriedCheckbox">Are you married?</label>
                                            <input @if ($find_user->married == 'married') checked @endif type="checkbox"
                                                id="marriedCheckbox" name="marriedCheckbox"
                                                onclick="toggleSpouseNameField()">
                                        </div>
                                        <div id="spouseNameDiv" class="mb-3 ">
                                            <label for="spouseName">Spouse Name:</label>
                                            <input type="text" id="spouseName" name="spouseName" class="form-control"
                                                value="@if ($find_user->spouse_name) {{ $find_user->spouse_name }} @endif">
                                            <div class="mb-3">


                                                @if ($find_user->childrean)
                                                    @php
                                                        // Split the children string into an array
                                                        $childrenArray = explode(',', $find_user->childrean);

                                                        // Remove empty values and trim whitespace
                                                        $childrenArray = array_filter(
                                                            array_map('trim', $childrenArray),
                                                        );

                                                        // Count the number of children
                                                        $childrenCount = count($childrenArray);
                                                    @endphp
                                                  @forelse($childrenArray as $key=>$child)
                                                  <div class="mb-3" id="child-input-{{ $key }}">
                                                      <label for="childName{{ $key }}" class="form-label">Child Name {{ $key + 1 }}</label>
                                                      <div class="input-group">
                                                          <input type="text" class="form-control" id="childName{{ $key }}" name="childName[]" value="{{ $child }}">
                                                          <button type="button" class="btn btn-danger" onclick="removeChildInput({{ $key }})">Delete</button>
                                                      </div>
                                                  </div>
                                              @empty
                                              @endforelse
                                              <script>
                                                function removeChildInput(key) {
                                                    var element = document.getElementById('child-input-' + key);
                                                    element.parentNode.removeChild(element);
                                                }
                                            </script>

                                                    <br>
                                                    <label for="childrenCheckbox">Do you have More Childrean?</label>
                                                    <input type="checkbox" id="childrenCheckbox" name="childrenCheckbox"
                                                        onclick="toggleChildrenFields()">
                                                @else
                                                    <input type="checkbox" id="childrenCheckbox" name="childrenCheckbox"
                                                        onclick="toggleChildrenFields()">
                                                @endif

                                            </div>
                                        </div>
                                    @else
                                        <div class="mb-3">
                                            <label for="marriedCheckbox">Are you married?</label>
                                            <input type="checkbox" id="marriedCheckbox" name="marriedCheckbox"
                                                onclick="toggleSpouseNameField()">
                                        </div>

                                        <div id="spouseNameDiv" class="mb-3 hidden">
                                            <label for="spouseName">Spouse Name:</label>
                                            <input type="text" id="spouseName" name="spouseName" class="form-control">
                                            <div class="mb-3">
                                                <label for="childrenCheckbox">Do you have children?</label>
                                                <input type="checkbox" id="childrenCheckbox" name="childrenCheckbox"
                                                    onclick="toggleChildrenFields()">
                                            </div>
                                        </div>
                                    @endif


                                    <div id="childrenDiv" class="mb-3 hidden">
                                        <label>Children's Names:</label>
                                        <div id="childrenContainer">
                                            <!-- Child name input fields will be added here -->
                                        </div>
                                        <button type="button" class="btn btn-success" onclick="addChildField()">Add
                                            Child</button>
                                        <button type="button" class="btn btn-danger" onclick="removeChildField()">Remove
                                            Child</button>

                                    </div>

                                    <div class="mb-3">
                                        <label for="Occupation">Occupation</label>
                                        <input type="text" name="occupation" class="form-control"
                                            value="{{ $find_user->occupation }}">
                                    </div>
                                    <div class="mb-3">
                                        <label for="Institute_name">Institute Name</label>
                                        <input type="text" name="institute_name" class="form-control"
                                            value="{{ $find_user->institute_name }}">
                                    </div>
                                    <div class="mb-3">
                                        <label for="present_address">Present Address</label>
                                        <textarea name="present_address" class="form-control" id="" cols="10" rows="5">
                            {{ $find_user->present_address }}
                            </textarea>
                                    </div>
                                    <div class="mb-3">
                                        <label for="present_address">Permanent Address</label>
                                        <textarea name="permanent_address" class="form-control" id="" cols="30" rows="5">
                                {{ $find_user->permanenet_address }}
                            </textarea>
                                    </div>
                                    <div class="mb-3">
                                        @php
                                        $Nid = asset('uploads/NID/' . $find_user->Nid);
                                    @endphp

                                        <label for="nid_file" class="form-label">Upload NID (PDF/Image)</label>
                                        {{ $find_user->Nid }}
                                        @if (pathinfo($Nid, PATHINFO_EXTENSION) == 'pdf')
                                        <iframe src="{{ $Nid }}" style="width:100%; height:500px;"
                                            frameborder="0"></iframe>
                                    @else
                                        <img src="{{ $Nid }}" alt="Office ID"
                                            style="width:20%;height:10%;">
                                    @endif

                                        <input type="file" class="form-control-file" id="nid_file" name="nid_file"
                                            accept=".pdf, image/*" onchange="previewFile(event, 'nid_preview')">

                                        <img src="{{ asset('uploads/NID/' . $find_user->Nid) }}" alt=""
                                            style="width:20%;height:10%;">
                                        <div id="nid_preview" class="preview">

                                        </div>
                                    </div>

                                    @php
                                        $officeIdFile = asset('uploads/OFFICE ID/' . $find_user->Office_id);
                                    @endphp
                                    <!-- File upload for Office ID -->
                                    <div class="mb-3">
                                        <label for="office_id_file" class="form-label">Upload Office ID
                                            (PDF/Image)</label>
                                        @if (pathinfo($officeIdFile, PATHINFO_EXTENSION) == 'pdf')
                                            <iframe src="{{ $officeIdFile }}" style="width:100%; height:500px;"
                                                frameborder="0"></iframe>
                                        @else
                                            <img src="{{ $officeIdFile }}" alt="Office ID"
                                                style="width:20%;height:10%;">
                                        @endif
                                        <input type="file" class="form-control-file" id="office_id_file"
                                            name="office_id_file" accept=".pdf, image/*"
                                            onchange="previewFile(event, 'office_id_preview')">
                                        <div id="office_id_preview" class="preview d-none"></div>
                                    </div>

                                    <!-- File upload for Your Own Picture -->
                                    <div class="mb-3">

                                        <img src="{{ asset('uploads/OWN IMAGE/' . $find_user->pictures) }}"
                                            alt="">
                                        <label for="own_picture_file" class="form-label">Upload Your Own Picture
                                            (Image)</label>
                                        <input type="file" class="form-control-file" id="own_picture_file"
                                            name="own_picture_file" accept="image/*"
                                            onchange="previewImage(event, 'picture_preview')">
                                        <img id="picture_preview" class="image-preview d-none">
                                    </div>


                                    <style>
                                        .form-control:focus {
                                            border: 1px solid green !important;
                                            box-shadow: 0 0 0 0.2rem rgba(0, 128, 0, 0.25);
                                        }
                                    </style>
                                    <style>
                                        .hidden {
                                            display: none;
                                        }

                                        .child-input {
                                            margin-bottom: 5px;
                                        }
                                    </style>


                                    <div class=" mb-3">
                                        <button class="btn btn-success w-100" type="submit">Working On Edit
                                            Purpose</button>

                                    </div>
                                </form>
                            </div>
                        @else
                            <div class="card-body">
                                <form method="POST" action="{{ route('user.submit_information') }}"
                                    enctype="multipart/form-data">
                                    @csrf

                                    @if ($errors->any())
                                        <div class="text-danger">
                                            {!! implode('', $errors->all('<div>:message</div>')) !!}
                                        </div>
                                    @endif
                                    <div class="mb-3 row">
                                        <!-- First Column -->
                                        {{-- <div class="col-md-4">
                                            <div id="nid_preview" class="preview" style="width: 200px; height: 200px; border: 1px solid #ccc; margin-bottom: 10px;"></div>
                                        
                                            <label for="pdf1" class="form-label">Upload NID (Image/PDF)</label>
                                            <input type="file" class="form-control" id="nid_file" name="nid_file" accept=".pdf, image/*" onchange="previewFile(event, 'nid_preview')">
                                        </div>
                                        <script>
                                            function previewFile(event, previewId) {
                                                const file = event.target.files[0];
                                                const preview = document.getElementById(previewId);
                                            
                                                if (file) {
                                                    const reader = new FileReader();
                                                    reader.onload = function(e) {
                                                        if (file.type.startsWith('image/')) {
                                                            preview.innerHTML = `<img src="${e.target.result}" style="max-width: 100%; max-height: 100%;" alt="Preview">`;
                                                        } else if (file.type === 'application/pdf') {
                                                            preview.innerHTML = `<embed src="${e.target.result}" width="100%" height="100%" type="application/pdf">`;
                                                        } else {
                                                            preview.innerHTML = 'File preview not available';
                                                        }
                                                        preview.classList.remove('d-none');
                                                    };
                                                    reader.readAsDataURL(file);
                                                } else {
                                                    preview.innerHTML = '';
                                                    preview.classList.add('d-none');
                                                }
                                            }
                                            </script>
                                            <style>
                                                .preview {
                                                    display: flex;
                                                    align-items: center;
                                                    justify-content: center;
                                                    overflow: hidden;
                                                }
                                                </style>
                                    
                                        <!-- Second Column -->
                                        <div class="col-md-4">
                                            <label for="pdf2_image" class="form-label">Office Id (Image/PDF)</label>
                                            <input type="file" class="form-control" name="pdf2_image" id="pdf2_image" accept="application/pdf, image/*">
                                        </div>
                                    
                                        <!-- Third Column -->
                                        <div class="col-md-4">
                                            <label for="image" class="form-label">Upload Own Image(only Image)</label>
                                            <input type="file" class="form-control" name="image" id="image" accept="image/*">
                                        </div> --}}
                                    </div>
                                    <div class="mb-3">
                                        <label for="name" class="form-label">Name(Nid)</label>
                                        <input type="text" class="form-control" name="name">
                                    </div>
                                    <div class="mb-3">
                                        <label for="father_name" class="form-label">Father's Name</label>
                                        <input type="text" class="form-control" name="father_name">
                                    </div>
                                    <div class="mb-3">
                                        <label for="mother_name" class="form-label">Mother's Name</label>
                                        <input type="text" class="form-control" name="mother_name">
                                    </div>
                                    <div class="mb-3">
                                        <label for="mother_name" class="form-label">Mother's Name</label>
                                        <input type="text" class="form-control" name="mother_name">
                                    </div>
                                    <div class="mb-3">
                                        <label for="gender" class="form-label">Gender</label>
                                        <select name="gender" id="" class="form-control">
                                            <option value="male">Male</option>
                                            <option value="Female">Female</option>

                                        </select>
                                    </div>
                                    <div class="mb-3">
                                        <label for="marriedCheckbox">Are you married?</label>
                                        <input type="checkbox" id="marriedCheckbox" name="marriedCheckbox"
                                            onclick="toggleSpouseNameField()">
                                    </div>

                                    <div id="spouseNameDiv" class="mb-3 hidden">
                                        <label for="spouseName">Spouse Name:</label>
                                        <input type="text" id="spouseName" name="spouseName" class="form-control">
                                        <div class="mb-3">
                                            <label for="childrenCheckbox">Do you have children?</label>
                                            <input type="checkbox" id="childrenCheckbox" name="childrenCheckbox"
                                                onclick="toggleChildrenFields()">
                                        </div>
                                    </div>

                                    <div id="childrenDiv" class="mb-3 hidden">
                                        <label>Children's Names:</label>
                                        <div id="childrenContainer">
                                            <!-- Child name input fields will be added here -->
                                        </div>
                                        <button type="button" class="btn btn-success" onclick="addChildField()">Add
                                            Child</button>
                                        <button type="button" class="btn btn-danger" onclick="removeChildField()">Remove
                                            Child</button>

                                    </div>

                                    <div class="mb-3">
                                        <label for="Occupation">Occupation</label>
                                        <input type="text" name="occupation" class="form-control">
                                    </div>
                                    <div class="mb-3">
                                        <label for="Institute_name">Institute Name</label>
                                        <input type="text" name="institute_name" class="form-control">
                                    </div>
                                    <div class="mb-3">
                                        <label for="present_address">Present Address</label>
                                        <textarea name="present_address" class="form-control" id="" cols="30" rows="5"></textarea>
                                    </div>
                                    <div class="mb-3">
                                        <label for="present_address">Permanent Address</label>
                                        <textarea name="permanent_address" class="form-control" id="" cols="30" rows="5"></textarea>
                                    </div>
                                    <div class="mb-3">
                                        <label for="nid_file" class="form-label">Upload NID (PDF/Image)</label>
                                        <input type="file" class="form-control-file" id="nid_file" name="nid_file"
                                            accept=".pdf, image/*" onchange="previewFile(event, 'nid_preview')">
                                        <div id="nid_preview" class="preview d-none"></div>
                                    </div>

                                    <!-- File upload for Office ID -->
                                    <div class="mb-3">
                                        <label for="office_id_file" class="form-label">Upload Office ID
                                            (PDF/Image)</label>
                                        <input type="file" class="form-control-file" id="office_id_file"
                                            name="office_id_file" accept=".pdf, image/*"
                                            onchange="previewFile(event, 'office_id_preview')">
                                        <div id="office_id_preview" class="preview d-none"></div>
                                    </div>

                                    <!-- File upload for Your Own Picture -->
                                    <div class="mb-3">
                                        <label for="own_picture_file" class="form-label">Upload Your Own Picture
                                            (Image)</label>
                                        <input type="file" class="form-control-file" id="own_picture_file"
                                            name="own_picture_file" accept="image/*"
                                            onchange="previewImage(event, 'picture_preview')">
                                        <img id="picture_preview" class="image-preview d-none">
                                    </div>


                                    <style>
                                        .form-control:focus {
                                            border: 1px solid green !important;
                                            box-shadow: 0 0 0 0.2rem rgba(0, 128, 0, 0.25);
                                        }
                                    </style>
                                    <style>
                                        .hidden {
                                            display: none;
                                        }

                                        .child-input {
                                            margin-bottom: 5px;
                                        }
                                    </style>


                                    <div class=" mb-3">
                                        <button class="btn btn-success w-100" type="submit">Register</button>

                                    </div>
                                </form>
                            </div>
                        @endif

                    </div>
                </div>
            @else
                 <div class="container">
                    <div class="row">
                        <div class="col-lg-8 col-sm-6 mx-auto">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="text-danger text-center">Please Login For Fill Up the Form</h3>
                                </div>
                            </div>
                        </div>
                    </div>
                 </div>
            @endif



        </div>


    </div>


    </div>

    <script>
        function previewFile(event, previewId) {
            var preview = document.getElementById(previewId);
            preview.classList.remove('d-none');

            var file = event.target.files[0];
            if (file.type.startsWith('image/')) {
                var reader = new FileReader();
                reader.onload = function() {
                    var img = document.createElement('img');
                    img.src = reader.result;
                    img.classList.add('img-thumbnail');
                    preview.innerHTML = ''; // Clear previous content
                    preview.appendChild(img);
                }
                reader.readAsDataURL(file);
            } else if (file.type === 'application/pdf') {
                var reader = new FileReader();
                reader.onload = function() {
                    var embed = document.createElement('embed');
                    embed.src = reader.result;
                    embed.type = 'application/pdf';
                    embed.classList.add('embed-responsive-item');
                    var container = document.createElement('div');
                    container.classList.add('embed-responsive', 'embed-responsive-4by3');
                    container.appendChild(embed);
                    preview.innerHTML = ''; // Clear previous content
                    preview.appendChild(container);
                }
                reader.readAsDataURL(file);
            } else {
                preview.textContent = 'File format not supported or recognized.';
            }
        }

        function previewImage(event, previewId) {
            var preview = document.getElementById(previewId);
            preview.classList.remove('d-none');

            var reader = new FileReader();
            reader.onload = function() {
                var img = document.createElement('img');
                img.src = reader.result;
                img.classList.add('img-thumbnail');
                preview.innerHTML = ''; // Clear previous content
                preview.appendChild(img);
            }
            reader.readAsDataURL(event.target.files[0]);
        }
    </script>

    <!---Add or remove child-->
    <script>
        function toggleSpouseNameField() {
            var checkbox = document.getElementById("marriedCheckbox");
            var spouseNameDiv = document.getElementById("spouseNameDiv");
            if (checkbox.checked) {
                spouseNameDiv.classList.remove("hidden");
            } else {
                spouseNameDiv.classList.add("hidden");
                document.getElementById("childrenCheckbox").checked = false;
                toggleChildrenFields(); // Hide children fields if "Are you married?" is unchecked
            }
        }

        function toggleChildrenFields() {
            var checkbox = document.getElementById("childrenCheckbox");
            var childrenDiv = document.getElementById("childrenDiv");
            if (checkbox.checked) {
                childrenDiv.classList.remove("hidden");
            } else {
                childrenDiv.classList.add("hidden");
                clearChildrenFields(); // Clear children fields if "Do you have children?" is unchecked
            }
        }

        function addChildField() {
            var container = document.getElementById("childrenContainer");
            var input = document.createElement("input");
            input.type = "text";
            input.name = "childName[]"; // Use array notation to submit multiple values
            input.classList.add("form-control", "child-input");
            container.appendChild(input);
        }

        function removeChildField() {
            var container = document.getElementById("childrenContainer");
            if (container.lastChild) {
                container.removeChild(container.lastChild);
            }
        }
    </script>


    <style>
        .preview {
            max-width: 100%;
            margin-top: 10px;
        }

        .image-preview {
            max-width: 100%;
            margin-top: 10px;
        }

        .embed-responsive-item {
            max-width: 100%;
            height: 100%;
        }

        .nid_preview {
            height: 20%;
            width: 20%;

        }
    </style>
    <script>
        AOS.init();
    </script>
    @if (session('success'))
        <script>
            const Toast = Swal.mixin({
                toast: true,
                position: "top-end",
                showConfirmButton: false,
                timer: 3000,
                timerProgressBar: true,
                didOpen: (toast) => {
                    toast.onmouseenter = Swal.stopTimer;
                    toast.onmouseleave = Swal.resumeTimer;
                }
            });
            Toast.fire({
                icon: "success",
                title: "{{ session('success') }}"
            });
        </script>
    @endif
    <!----Footer-->
    </section>
@endsection


<!-- ################# Our Blog Starts Here#######################--->


{{-- @include('Frontend.footer') --}}







{{-- </body>

<script src="{{ asset('Frontend_assets/assets/js/jquery-3.2.1.min.js') }}"></script>
<script src="{{ asset('Frontend_assets/assets/js/popper.min.js') }}"></script>
<script src="{{ asset('Frontend_assets/assets/js/bootstrap.min.js') }}"></script>
<script src="{{ asset('Frontend_assets/assets/js/script.js') }}"></script>


</html> --}}
