<?php

use App\Http\Controllers\AdminController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\PageController;
use App\Http\Controllers\SingleOnGoing;
use App\Http\Controllers\WebsiteSettingController;
use App\Models\Carousel;
use App\Models\Found_model;
use App\Models\Icon;
use App\Models\Image_gallery;
use App\Models\Logo;
use App\Models\on_going_project;
use App\Models\our_history;
use App\Models\Our_vision;
use App\Models\Promo_section;
use App\Models\Top_header;
use App\Models\Upcoming_project;
use App\Models\You_tube_model;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;

Route::get('/homes', function () {
    return view('welcome');
});

// Route::get('/',[PageController::class,'home_page']);
Route::get('/user/register',[PageController::class,'user_register'])->name('guest_user.register');
Route::get('/guest_user/profile_page',[PageController::class,'guest_user_profile_page'])->name('guest_user.profile_page');
Route::get('/user/form',[PageController::class,'user_form'])->name('user.form');
Route::post('/user/submit_information',[PageController::class,'user_submit_information'])->name('user.submit_information');
Route::post('/user/update_information',[PageController::class,'user_update_information'])->name('user.update_information');
Route::get('/galleries',[PageController::class,'galleries'])->name('user.galleries');
Route::get('/blogs/list',[PageController::class,'blog_list'])->name('user.blog_list');
Route::get('/user/you_tube_list',[PageController::class,'user_you_tube_list'])->name('user.you_tube_list');
Route::get('/user/profile',[PageController::class,'user_profile'])->name('user.profile');
Route::post('/user/profile/edit',[PageController::class,'user_profile_edit'])->name('user_profile.edit');











Auth::routes();

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');





//Admin Register Login
Route::get('/admin_login',[AdminController::class,'admin_login_page'])->name('admin.login_page');
Route::post('/admin_login',[AdminController::class,'admin_login_post'])->name('admin.login');
Route::get('/admin_page',[AdminController::class,'admin_page'])->name('admin.page')->middleware('Admin_middleware');
Route::get('/admin/logout',[AdminController::class,'admin_logout'])->name('admin.logout')->middleware('Admin_middleware');
Route::get('admin/req_user_details/{id}',[AdminController::class,'req_user_details'])->name('admin.req_user_details');


Route::get('admin/accept/req_user/{id}',[AdminController::class,'accept_request'])->name('accept.req_user');

Route::get('admin/not_accept/req_user/{id}',[AdminController::class,'not_accept_request'])->name('not_accept.req_user');
Route::get('admin/profile',[AdminController::class,'admin_profile'])->name('admin.profile');
Route::post('admin/update',[AdminController::class,'admin_update'])->name('admin.update');





//Website Settings By Admin 
Route::prefix('admin')->name('admin.')->middleware('Admin_middleware')->group(function () {
    Route::get('/top_header', [WebsiteSettingController::class, 'admin_top_header'])->name('top_header');
    Route::post('/top_header_insert', [WebsiteSettingController::class, 'admin_top_header_insert'])->name('top_header_insert');
    Route::post('/logo', [WebsiteSettingController::class, 'logo'])->name('logo');
    Route::post('/carousel', [WebsiteSettingController::class, 'admin_carousel'])->name('carousel');
    Route::get('/carousel_inactive/{id}', [WebsiteSettingController::class, 'carousel_inactive'])->name('carousel_inactive');
    Route::get('/carousel_active/{id}', [WebsiteSettingController::class, 'carousel_active'])->name('carousel_active');

    Route::get('/admin/promo_section', [WebsiteSettingController::class, 'promo_section'])->name('promo_section');
    Route::post('/admin/promo_section_1', [WebsiteSettingController::class, 'promo_section_1'])->name('promo_section_1');
    Route::post('/admin/promo_section_2', [WebsiteSettingController::class, 'promo_section_2'])->name('promo_section_2');
    Route::post('/admin/promo_section_3', [WebsiteSettingController::class, 'promo_section_3'])->name('promo_section_3');



    Route::get('/admin/who_we_are', [WebsiteSettingController::class, 'who_we_are'])->name('who_we_are');

    Route::post('/admin/founder_description', [WebsiteSettingController::class, 'founder_description'])->name('founder_description');

    Route::post('/admin/our_history', [WebsiteSettingController::class, 'our_history'])->name('our_history');
    Route::post('/admin/our_vision', [WebsiteSettingController::class, 'our_vision'])->name('our_vision');
    // Route::post('/admin/our_recent_programme', [WebsiteSettingController::class, 'our_vision'])->name('our_vision');
    Route::get('/admin/on_going_project', [WebsiteSettingController::class, 'on_going_project'])->name('on_going_project');
    Route::post('/admin/ongoin_project_store', [WebsiteSettingController::class, 'on_going_project_store'])->name('ongoin_project_store');
   
    Route::get('/admin/ongoing_project_details/{id}', [WebsiteSettingController::class, 'ongoing_project_details'])->name('ongoing_project_details');
    Route::post('/admin/edit_ongoing_project/{id}', [WebsiteSettingController::class, 'edit_ongoing_project'])->name('edit_ongoing_project');
    Route::get('/admin/ongoing_project_first_page/{id}', [WebsiteSettingController::class, 'ongoing_project_first_page'])->name('ongoing_project_first_page');
    Route::get('/admin/ongoing_project_first_page_not_showing/{id}', [WebsiteSettingController::class, 'ongoing_project_first_page_not_showing'])->name('ongoing_project_first_page_not_showing');
    Route::get('/admin/ ongoing_project_delete/{id}', [WebsiteSettingController::class, 'ongoing_project_delete'])->name('ongoing_project_delete');
    Route::get('/admin/upcoming_project/', [WebsiteSettingController::class, 'upcoming_project'])->name('upcoming_project');
    Route::post('/admin/upcoming_project_store/', [WebsiteSettingController::class, 'upcoming_project_store'])->name('upcoming_project_store');
    Route::get('/admin/upcoming_project_single_show/{id}', [WebsiteSettingController::class, 'upcoming_project_single_show'])->name('upcoming_project_single_show');
    Route::post('/admin/upcoming_project_edit/{id}', [WebsiteSettingController::class, 'upcoming_project_edit'])->name('upcoming_project_edit');
    Route::get('/admin/upcoming_project_first_page_show/{id}', [WebsiteSettingController::class, 'upcoming_project_first_page_show'])->name('upcoming_project_first_page_show');
    Route::get('/admin/upcoming_project_first_page_not_show/{id}', [WebsiteSettingController::class, 'upcoming_project_first_page_not_show'])->name('upcoming_project_first_page_not_show');
    Route::get('/admin/upcoming_project_delete/{id}', [WebsiteSettingController::class, 'upcoming_project_delete'])->name('upcoming_project_delete');
    Route::get('/admin/you_tube_videos/', [WebsiteSettingController::class, 'you_tube_videos'])->name('you_tube_videos');
    Route::post('/admin/you_tube_store/', [WebsiteSettingController::class, 'you_tube_store'])->name('you_tube_store');
    Route::post('/admin/you_tube_edit/{id}', [WebsiteSettingController::class, 'you_tube_edit'])->name('you_tube_edit');
    Route::get('/admin/you_tube_delete/{id}', [WebsiteSettingController::class, 'you_tube_delete'])->name('you_tube_delete');
    Route::get('/admin/image_gallery/', [WebsiteSettingController::class, 'image_gallery'])->name('image_gallery');
    Route::post('/admin/image_gallery_post/', [WebsiteSettingController::class, 'image_gallery_post'])->name('image_gallery_post');
    Route::get('/admin/image_delete/{id}', [WebsiteSettingController::class, 'image_delete'])->name('image_delete');
    Route::get('/admin/add_icon/', [WebsiteSettingController::class, 'add_icon'])->name('add_icon');
    Route::post('/admin/icon_post/', [WebsiteSettingController::class, 'icon_post'])->name('icon_post');
    Route::post('/admin/send_short_note/{id}', [WebsiteSettingController::class, 'send_short_note'])->name('send_short_note');


    
 
    

    
    
    

   

    
   
    
    
    


    
    
    
    

   

    
    
    
});


Route::get('/logout',[AdminController::class,'logout'])->name('user.logout');


Route::get('/single_on_going/{id}',[SingleOnGoing::class,'single_on_going'])->name('single_on_going');
Route::get('/on_going_project/list',[SingleOnGoing::class,'on_going_project'])->name('on_going_project');
Route::get('/upcoming_project_details/{id}',[SingleOnGoing::class,'upcoming_project_details'])->name('upcoming_project_details');




Route::get('/',function(){
    $top_header = Top_header::first();
    $logo = Logo::first();
    $carousel = Carousel::where('status',1)->get();
    $promo_section_1 = Promo_section::where('count',1)->first();
    $promo_section_2 = Promo_section::where('count',2)->first();
    $promo_section_3 = Promo_section::where('count',3)->first();
    $founder = Found_model::first();
    $history = our_history::first();
    $our_vision = Our_vision::first();
    $ong_going_project = on_going_project::where('first_page',1)->get();
     $upcoming_project = Upcoming_project::where('first_page',1)->get();
     $you_tube_video = You_tube_model::orderBy('created_at', 'desc')->take(6)->get();
     $image_gallery = Image_gallery::orderBy('created_at', 'desc')->take(6)->get();
     $icons = Icon::all();

     return view('Frontend_1.layouts.master');
   
});
Route::get('/checks',function(){
    

     return view('Frontend_1.layouts.master');
        
});
Route::get('/user_logout',function(){
    Auth::logout();
    return redirect('/');

});





