
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-lg-6 col-sm-4 mx-auto">
            <div class="card">
                <div class="card-header">
                    <h3>
                        Image Gallery
                    </h3>
                    <?php if($errors->any()): ?>
                        <?php echo implode('', $errors->all('<div class="text-danger">:message</div>')); ?>

                    <?php endif; ?>
                </div>
                <div class="card-body">
                    <form action="<?php echo e(route('admin.image_gallery_post')); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>

                        <div class="mb-3">
                            <label for="" class="form-label">Title</label>
                            <input type="text" class="form-control" name="title">

                        </div>
                        <div class="mb-3">
                            <label for="logo" class="form-label">Thumbnail Image</label>
                            <input type="file" name="thumbnail" id="thumbnail_image" class="form-control" accept="image/*">
                        </div>
                        <div class="mb-3">
                            <div id="thumbnail_images" class="d-flex justify-content-center align-items-center"
                                style="border: 1px solid #ddd; padding: 10px; border-radius: 5px; width: 100%; height: 200px; background-color: #f8f9fa;">
    
                               
    
    
                            </div>
                        </div>

                        <div class="mb-3">
                            <button type="submit" class="btn btn-primary w-100">Insert</button>
                        </div>
                </div>
                </form>
            </div>

        </div>
    </div>
    <div class="container py-5">
        <div class="row">
            <?php $__empty_1 = true; $__currentLoopData = $image_gallery; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $images): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="col-lg-4 col-md-4 col-sm-6 mb-4">
                    <div class="card you_tube  shadow-sm" style="min-height:300px;">
                        <div class="ratio ratio-16x9" style="height:200px;">
                           <img src="<?php echo e(asset('/')); ?><?php echo e($images->image); ?>" alt="" style="height:100%;width:100%;background-size:cover;background-position:center;">
                        </div>
                        <div class="card-body">
                            <p class="card-title"><?php echo e($images->title); ?></p>
                            
                                    <a href="<?php echo e(route('admin.image_delete',$images->id)); ?>" type="button" class="btn btn-danger"
                                        data-id="<?php echo e($images->id); ?>" data-title="<?php echo e($images->title); ?>"><i class="fas fa-trash"></i></a>
        


                        </div>
                    </div>
                </div>
                
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="col-12">
                    <p class="text-center text-muted">No videos available</p>
                </div>
            <?php endif; ?>
        </div>
       
    </div>
    <style>
        .card-title {
            font-size: 1.25rem;
            font-weight: 600;
            color: #333;
        }

        .you_tube {

            transition: transform 0.2s;
        }

        .card:hover {
            transform: translateY(-10px);
            box-shadow: 0 8px 16px rgba(0, 0, 0, 0.2);
        }

        .container {
            padding-top: 20px;
        }

        .ratio {
            overflow: hidden;
        }

        .ratio iframe {
            border-radius: 0.25rem 0.25rem 0 0;
        }

        .card-body {
            background-color: #f8f9fa;
            border-top: 1px solid #e9ecef;
        }
    </style>




    <script>
        $(document).ready(function() {
            $('#summernote').summernote({
                placeholder: 'Type Here',
                tabsize: 2,
                height: 120,
                toolbar: [
                    ['style', ['style']],
                    ['font', ['bold', 'underline', 'clear']],
                    ['color', ['color']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['table', ['table']],
                    ['insert', ['link', 'picture', 'video']],
                    ['view', ['fullscreen', 'codeview', 'help']]
                ]
            });
        });
    </script>
    <script>
        $(document).ready(function() {
            $('#thumbnail_image').change(function(event) {
                const imagePreview = $('#thumbnail_images');
                imagePreview.empty();

                const file = event.target.files[0];
                if (file) {
                    const reader = new FileReader();
                    reader.onload = function(e) {
                        const img = $('<img>').attr('src', e.target.result).css({
                            'max-width': '100%',
                            'max-height': '100%'
                        });
                        imagePreview.append(img);
                    }
                    reader.readAsDataURL(file);
                } else {
                    imagePreview.html('<span class="text-muted">Image preview will appear here</span>');
                }
            });
        });
    </script>

    <script>
        $(document).ready(function() {
            $('#promo_2').change(function(event) {
                const imagePreview = $('#imagePreview_promo');
                imagePreview.empty();

                const file = event.target.files[0];
                if (file) {
                    const reader = new FileReader();
                    reader.onload = function(e) {
                        const img = $('<img>').attr('src', e.target.result).css({
                            'max-width': '100%',
                            'max-height': '100%'
                        });
                        imagePreview.append(img);
                    }
                    reader.readAsDataURL(file);
                } else {
                    imagePreview.html('<span class="text-muted">Image preview will appear here</span>');
                }
            });
        });
    </script>

    <script>
        $(document).ready(function() {
            $('#promo_3').change(function(event) {
                const imagePreview = $('#imagePreview_promo3');
                imagePreview.empty();

                const file = event.target.files[0];
                if (file) {
                    const reader = new FileReader();
                    reader.onload = function(e) {
                        const img = $('<img>').attr('src', e.target.result).css({
                            'max-width': '100%',
                            'max-height': '100%'
                        });
                        imagePreview.append(img);
                    }
                    reader.readAsDataURL(file);
                } else {
                    imagePreview.html('<span class="text-muted">Image preview will appear here</span>');
                }
            });
        });
    </script>

    <script>
        $(document).ready(function() {
            $('#slider').change(function(event) {
                const imagePreview = $('#imagePreview_carousel');
                imagePreview.empty();

                const file = event.target.files[0];
                if (file) {
                    const reader = new FileReader();
                    reader.onload = function(e) {
                        const img = $('<img>').attr('src', e.target.result).css({
                            'max-width': '100%',
                            'max-height': '100%'
                        });
                        imagePreview.append(img);
                    }
                    reader.readAsDataURL(file);
                } else {
                    imagePreview.html('<span class="text-muted">Image preview will appear here</span>');
                }
            });
        });
    </script>

    <?php if(session('success')): ?>
        <script>
            const Toast = Swal.mixin({
                toast: true,
                position: "top-end",
                showConfirmButton: false,
                timer: 3000,
                timerProgressBar: true,
                didOpen: (toast) => {
                    toast.onmouseenter = Swal.stopTimer;
                    toast.onmouseleave = Swal.resumeTimer;
                }
            });
            Toast.fire({
                icon: "success",
                title: "<?php echo e(session('success')); ?>"
            });
        </script>
    <?php endif; ?>

    <?php if(session('error')): ?>
        <script>
            const Toast = Swal.mixin({
                toast: true,
                position: "top-end",
                showConfirmButton: false,
                timer: 3000,
                timerProgressBar: true,
                didOpen: (toast) => {
                    toast.onmouseenter = Swal.stopTimer;
                    toast.onmouseleave = Swal.resumeTimer;
                }
            });
            Toast.fire({
                icon: "error",
                title: "<?php echo e(session('success')); ?>"
            });
        </script>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('Admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH H:\Bilal vai\Project\project_ngo\resources\views/Admin/Webiste_settings/image_gallery.blade.php ENDPATH**/ ?>